USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetFacilitiesByVISNIDs1]    Script Date: 6/14/2016 9:14:46 AM ******/
DROP PROCEDURE [dbo].[usp_GetFacilitiesByVISNIDs1]
GO

/****** Object:  StoredProcedure [dbo].[usp_GetFacilitiesByVISNIDs1]    Script Date: 6/14/2016 9:14:46 AM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO



CREATE PROCEDURE [dbo].[usp_GetFacilitiesByVISNIDs1]
	@USER_NAME NVARCHAR(100),
	@VISN_IDS NVARCHAR(MAX)
AS
BEGIN
	
	--create temporary VISN table
	DECLARE @TBL_VISN TABLE (ID INT, CODE NVARCHAR(2))
	
	INSERT INTO @TBL_VISN(ID, CODE) 
	SELECT CAST(VALUE AS INT), V_ORG.CODE
	FROM dbo.ufn_Split(@VISN_IDS, ',') AS V
	INNER JOIN dbo.DIM_ORGANIZATION AS V_ORG ON V_ORG.ID = V.VALUE 
	
	-- create permission table
	CREATE TABLE #PERMISSION
        (
         DIM_ORGANIZATION_ID INT,
         DIM_WARD_ID INT
        )
    
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
	
	CREATE TABLE #FACILTIES (ID INT, NAME NVARCHAR(260), VISN_CODE INT)
	INSERT INTO #FACILTIES(ID, NAME, VISN_CODE)
	SELECT FACILITY.ID, 'V' + VISN.CODE + ' - ' + FACILITY.CODE + ' - ' + FACILITY.NAME, CAST(VISN.CODE AS INT)
	FROM DIM_ORGANIZATION AS FACILITY
	INNER JOIN #PERMISSION AS PERMISSION ON PERMISSION.DIM_ORGANIZATION_ID = FACILITY.ID
	INNER JOIN DIM_ORGANIZATION AS VISTA_SITE ON FACILITY.DIM_ORGANIZATION_ID = VISTA_SITE.ID
	INNER JOIN @TBL_VISN AS VISN ON VISN.ID = VISTA_SITE.DIM_ORGANIZATION_ID
	
	
	SELECT F.F_ID +'_'+cast(row_number() over( order by F.F_ID asc) as varchar(100)) as ID, F.NAME
	FROM(
	SELECT CAST(ID AS VARCHAR(100))+';'+ CAST(row_number() over( order by ID desc) AS VARCHAR(100) )as F_ID, NAME, VISN_CODE
    FROM #FACILTIES
    )F
	ORDER BY F.VISN_CODE,F.NAME
	
	DROP TABLE #FACILTIES
	DROP TABLE #PERMISSION
END


GO


